function saveOptions(e) {
    e.preventDefault();
    browser.storage.local.set({
        POSIP: document.querySelector("#PkhPayIP").value,
        POSID: document.querySelector("#PosID").value,
        OFFICEID: document.querySelector("#PkhPayOffice").value
    });
}

function restoreOptions() {

    function setCurrentChoice1(result) {
        document.querySelector("#PkhPayIP").value = result.POSIP || "0.0.0.0";
    }
    function setCurrentChoice2(result) {
        document.querySelector("#PosID").value = result.POSID || "00000000";
    }
    function setCurrentChoice3(result) {
        document.querySelector("#PkhPayOffice").value = result.OFFICEID || "72000000";
    }

    function onError(error) {
        console.log(`Error: ${error}`);
    }

    var getting1 = browser.storage.local.get("POSIP");
    getting1.then(setCurrentChoice1, onError);
    var getting2 = browser.storage.local.get("POSID");
    getting2.then(setCurrentChoice2, onError);
    var getting3 = browser.storage.local.get("OFFICEID");
    getting3.then(setCurrentChoice3, onError);
}

document.addEventListener("DOMContentLoaded", restoreOptions);
document.querySelector("form").addEventListener("submit", saveOptions);