var POSIP = '';
var POSID = '';
var OFFICEID = '';
var manifest = browser.runtime.getManifest();
//var ValidOrigins = ["http://localhost", "http://iec", "http://iec24.epishkhan.ir", "http://iec24.com", "http://www.iec24.com", "http://ncr.epishkhan.ir"];

function onError(error) {
    "use strict";
    console.log('Error: ',error);
}

function initialize() {
  var gettingAllStorageItems = browser.storage.local.get(null);
  gettingAllStorageItems.then((results) => {
    var options = Object.keys(results);
    for (let option of options) {
        if(option == 'OFFICEID')
        {
            OFFICEID = results[option];
        }
        if(option == 'POSID')
        {
            POSID = results[option];
        }
        if(option == 'POSIP')
        {
            POSIP = results[option];
        }
    }
//    console.log("cs|pg|isalive|" + manifest.version + "#" + POSIP + "#" + POSID + "#" + OFFICEID);    
    window.postMessage("cs|pg|isalive|" + manifest.version + "#" + POSIP + "#" + POSID + "#" + OFFICEID, "*");
  }, onError);
}

browser.storage.onChanged.addListener(function (changes, area) {
    "use strict";
    var changedItems = Object.keys(changes);

    for (var item of changedItems) {
        if (item == 'POSIP')
        {
            POSIP = changes[item].newValue;
        }
        if (item == 'POSID')
        {
            POSID = changes[item].newValue;
        }
        if (item == 'OFFICEID')
        {
            OFFICEID = changes[item].newValue;
        }
    }
});

browser.runtime.onMessage.addListener(function (m) {
//    console.log("In content script, received message from background script: ", m);
    if (m.hasOwnProperty('action')) {
        switch (m.action) {
            case 'ad|cs|isalive':
                initialize();
                break;
            case 'ad|cs|payres':
                window.postMessage("cs|pg|payres|" + m.arg[0], "*");
//                console.log("cs|pg|payres|" + m.arg[0]);
                break;
            case 'ad|cs|conerr':
            if (m.arg[0] == 1) {
                    window.postMessage("cs|pg|conerr|" + m.message, "*");
                } else {
                    window.postMessage("cs|pg|conerr|connection error!(2152398862)", "*");
                }
                break;
            default://unknown action
//                console.log('unknown action:', m.action);
                break;
        }
    }
});

// listen to window.postMessag
window.addEventListener('message', function (event) {
    /*if (ValidOrigins.indexOf(event.origin) < 0) {
     console.log('error: Message with invalid Origin [' + event.origin + ']', 'Message Data is: ' + event.data);
     return;
     }*/
    if (typeof event.data !== 'undefined')
    {
        var dataArray = event.data.split("|");
        if (dataArray[1] == 'cs')
        {
            switch (dataArray[0])//check sender
            {
                case 'pg'://sender is pospay.js from iec
//                    console.log("message from Page:", event.data);
                    switch (dataArray[2])
                    {
                        case 'pay'://simple payment
                            //myPort.postMessage({action: 'cs|ad|pay', arg: dataArray[3]});
//                            console.log('message:', { action: 'cs|ad|pay', arg: dataArray[3] });
                            browser.runtime.sendMessage({ action: 'cs|ad|pay', arg: dataArray[3] });
                            break;
                        case 'isalive'://simple payment
                            //myPort.postMessage({action: 'cs|ad|pay', arg: dataArray[3]});
//                            console.log('message:', { action: 'cs|ad|cs|ad|isalive', arg: dataArray[3] });
                            browser.runtime.sendMessage({ action: 'cs|ad|isalive', arg: dataArray[3] });
                            break;
                        default:
//                            console.log('case not found: ' + dataArray[2]);
                            return;
                    }
                    break;
                default:
                    windows.alert('case not found: ' + dataArray[0]);
                    return;
            }
        }
    }
}, false);

browser.runtime.sendMessage({ action: 'cs|ad|isalive', arg: '' });