var portFromCS, POSIP, POSID, OFFICEID, _websocket;
var manifest = browser.runtime.getManifest();

function onError(error) {
    "use strict";
    console.log('Error: ',error);
}

function onGot(item) {
    "use strict";
    if (item.POSIP) {
        POSIP = item.POSIP;
    }
    if (item.POSID) {
        POSID = item.POSID;
    }
    if (item.OFFICEID) {
        OFFICEID = item.OFFICEID;
    }
}

var getting1 = browser.storage.local.get("POSIP");
getting1.then(onGot, onError);
var getting2 = browser.storage.local.get("POSID");
getting2.then(onGot, onError);
var getting3 = browser.storage.local.get("OFFICEID");
getting3.then(onGot, onError);

browser.storage.onChanged.addListener(function (changes, area) {
    "use strict";
    var changedItems = Object.keys(changes);

    for (var item of changedItems) {
        if (item == 'POSIP')
        {
            POSIP = changes[item].newValue;
        }
        if (item == 'POSID')
        {
            POSID = changes[item].newValue;
        }
        if (item == 'OFFICEID')
        {
            OFFICEID = changes[item].newValue;
        }
    }
});

browser.runtime.onMessage.addListener(MessageD);

function MessageD(request, sender, sendResponse) {
    if (request && typeof request.action !== "undefined")
    {
        switch (request.action) {
            case 'cs|ad|pay':
                talk2POS(request.arg, sender.tab.id);
                break;
            case 'cs|ad|isalive':
                //    console.log('Sending is alive to CS');
                browser.tabs.sendMessage(sender.tab.id, { action: "ad|cs|isalive", arg: [], message: 'calling isalive!', status: true });
                break;
            default: //unknown action
                //                    console.log('unknown action:', m.action);
                break;
        }
    }
}

function wsConnect(POSInput, targetTAB) {
    if (_websocket) {
        _websocket.close();
    } else {
        var getting1 = browser.storage.local.get("POSIP");
        getting1.then(onGot, onError);
//        console.log('getting pos ip:', POSIP);
        if (typeof POSIP === "undefined" || POSIP === '')
        {
            browser.tabs.sendMessage(targetTAB, { action: "ad|cs|conerr", arg: [1], message: 'آدرس IP کارتخوان در تنظیمات افزونه نامعتبر است' , status: false });
            return;
        }
        var url = "ws://" + POSIP + ":5432";
//        console.log('Connecting to :', url);
        _websocket = new WebSocket(url);
        _websocket.onopen = function () {
//            console.log('Connected!');
            // Web Socket is connected, send data using send()
            var POSInputArray = POSInput.split("#");
            _websocket.send(POSInputArray[0]);
//            console.log('sending ' + POSInputArray[0] + ' to POS');
        };
        _websocket.onmessage = function (msg) {
//            console.log("Sending close connection to POS");
            _websocket.close();
            var received_msg = msg.data;
            handlePOSAnswer(POSInput, received_msg, targetTAB);
//            console.log("message from pos received at background: ",msg);
        };

        _websocket.onclose = function (evt) {
//            console.log("Connection closed by POS: ",evt);
            _websocket = null;
        };

        _websocket.onerror = function (evt) {
//            console.log("POS Connection error: ",evt);
            if (_websocket.readyState == 1) {
                browser.tabs.sendMessage(targetTAB, { action: "ad|cs|conerr", arg: [_websocket.readyState], message: 'Error: ' + evt.type, status: false });
//                console.log('ws normal error: ' + evt.type);
            } else {
                browser.tabs.sendMessage(targetTAB, { action: "ad|cs|conerr", arg: [_websocket.readyState], message: 'Error2!', status: false });
//                console.log('ws error: ', evt);
            }
        };
    }
}

function talk2POS(POSInput,targetTAB) {
    if (typeof POSInput !== 'undefined')
    {
//        console.log("Talking to POS:", POSInput);
        wsConnect(POSInput, targetTAB);
    } else {
//        console.log("POS String is empty!");
    }

}

function handlePOSAnswer(POSInput, POSOutput, targetTAB) {
//    console.log("Answer from POS:", POSOutput);
    var POSInputArray = POSInput.split("#");
    var newRes = POSOutput + "#" + POSInputArray[1];
    browser.tabs.sendMessage(targetTAB, { action: "ad|cs|payres", arg: [newRes], message: 'success', status: true });
}